; Diagnostic ROM part 5
; 
; Author Dwight Elvey
;
; Converted to standard assembler Hans Otten, 2025
;
; Standard Defines KIM-1
;
; I/O in 6530-002
;
SAD     =     $1740             ; 6530 A DATA
PADD    =     $1741             ; 6530 A DATA DIRECTION
SBD     =     $1742             ; 6530 B DATA
PBDD    =     $1743             ; 6530 B DATA DIRECTION
CLK1T   =     $1744             ; DIV BY 1 TIME
CLK8T   =     $1745             ; DIV BY 8 TIME
CLK64T  =     $1746             ; DIV BY 64 TIME
CLKKT   =     $1747             ; DIV BY 1024 TIME
CLKRDI  =     $1747             ; READ TIME OUT BIT
CLKRDT  =     $1746             ; READ TIME
;
;
; I/O in 6530-002
;
SAD1     =     $1700             ; 6530 A DATA
PADD1    =     $1701             ; 6530 A DATA DIRECTION
SBD1     =     $1702             ; 6530 B DATA
PBDD1    =     $1703             ; 6530 B DATA DIRECTION
CLK1T1   =     $1704             ; DIV BY 1 TIME
CLK8T1   =     $1705             ; DIV BY 8 TIME
CLK64T1  =     $1706             ; DIV BY 64 TIME
CLKKT1   =     $1707             ; DIV BY 1024 TIME
CLKRDI1  =     $1707             ; READ TIME OUT BIT
CLKRDT1  =     $1706             ; READ TIME

; Zero page 6530--002
;
;
TEMP	= 	  $F8
INH     =     $F9               ; INPUT BUFFER
POINTL  =     $FA               ; LSB OF OPEN CELL
POINTH  =     $FB               ; MSB OF OPEN CELL
CNT		=	  $FC				; counter
;
; KIM-1 Routines
;
SCANDS  = $1F1F
KEYIN   = $1F40
GETKEY  = $1F6A

; Test 5 CRC3
;  Switch setting:
;   DB on
;  --
;   S0 off
;   S1 on
;   S2 off
;   S3 on
;  This test the ROM data for -003. It is the same as CRC2 but the
; CRC numbers are 5EA4 instead, for the -003 chip.
; This does a crc of the -003 ROM
; a good CRC is 5EA4
; This expects a working CRC
; The CRC is flashed on the CRC. The code runs repeatedly
; to help any debug.

	.ORG $0C00
TABLE	
        .byte $BF
        .byte $86
        .byte $DB
        .byte $CF
        .byte $E6
        .byte $ED
        .byte $FD
        .byte $87
        .byte $FF
        .byte $EF
        .byte $F7
        .byte $FC
        .byte $B9
        .byte $DE
        .byte $F9
        .byte $F1
CRC					; calculate checksum	
		  EOR  $00  	; add byte to checksum
;		
          STA $00
          LSR A
          LSR A
          LSR A
          LSR A
          TAX
          ASL A
          EOR $01
          STA $01
          TXA
          EOR $00
          STA $00
          ASL A
          ASL A
          ASL A
          TAX
          ASL A
          ASL A
          EOR $00
          TAY
          TXA
          ROL A
          EOR $01
          STA $00
          STY $01
          RTS
		  
DISPCRC LDX #$0F			; show checksum on CRC, $05-$09
          LDY #$04
LOOP      LDA $0005,Y		; checksum converted to hex
          STY $05
          TAY
          LDA TABLE,Y
          LDY #$00			; init RRIOT Ports
          STY $1740
          STX $1742
          STA $1740
          LDY #$FF			; delay
LY		  NOP
          NOP
          NOP
          NOP
          DEY
          BNE LY
          DEX
          DEX
          LDY $1742
          LDY $05
          DEY
          BNE LOOP
          LDY #$01
          STY $1742
          RTS
RESET		  
          LDX #$FF
          TXS
          LDX #$FF
          STX $1741
          LDX #$00
          STX $1740
          LDX #$3F
          STX $1743
          LDX #$01
          STX $1742
          CLD
          LDA #$FF
          STA $00
          STA $01
          LDA #$00
          STA $02
          LDA #$18			; start of 6530-003 ROM $1800
          STA $03
          LDX #$04
          LDY #$00
L1490     STX $04
L1492     STY $05
          LDA ($02),Y		; load byte from ROM
          JSR CRC		; add to checksum
          LDY $05
          INY
          BNE L1492
          LDX $03
          INX
          STX $03
          LDX $04
          DEX
          BNE L1490
          LDA $00			; checksum binary to hex
          AND #$0F
          STA $09
          LDA $00
          AND #$F0
          LSR A
          LSR A
          LSR A
          LSR A
          STA $08
          LDA $01
          AND #$0F
          STA $07
          LDA $01
          AND #$F0
          LSR A
          LSR A
          LSR A
          LSR A
          STA $06
          JSR DISPCRC
          JMP RESET
 
;
HEREV
		.FILL (VECTOR - HEREV)&$FFF, 0
		  .ORG $FFFA
VECTOR		  


;
; Reset vectors
;	

          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
          .BYTE RESET&255
          .BYTE RESET/256
		 .END